<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="de"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8" lang="de"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9" lang="de"> <![endif]-->
<!--[if gt IE 8]><!-->

<html class="no-js" lang="de">
<!--<![endif]-->

<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">

<title>Benutzerkonto Unternehmen — mindsetters</title>

<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="apple-touch-icon" sizes="180x180" href="assets/favicons/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="assets/favicons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="assets/favicons/favicon-16x16.png">
<link rel="manifest" href="assets/favicons/site.webmanifest">
<link rel="mask-icon" href="assets/favicons/safari-pinned-tab.svg" color="#242858">
<link rel="shortcut icon" href="assets/favicons/favicon.ico">
<meta name="msapplication-TileColor" content="#242858">
<meta name="msapplication-config" content="assets/favicons/browserconfig.xml">
<meta name="theme-color" content="#242858">

<link rel="stylesheet" href="assets/css/styles.css?<?php echo time(); ?>">

<script src="assets/js/jquery.js?<?php echo time(); ?>"></script>
<script src="assets/js/jquery-migrate.js?<?php echo time(); ?>"></script>
<script src="assets/js/modernizr.js"></script>

</head>

<body>
	
<div class="subpage">
	<nav id="nav">
		<a href="/" class="mindsetters-icon"><img src="assets/svg/icon-blue.svg" alt="mindsetters"></a>
		<ul class="nav">
			<li><a href="company-training">Schulungen</a></li>
			<li><a href="company-users">MitarbeiterInnen</a></li>
			<li><a href="company-profile">Unternehmensdaten</a></li>
			<li class="active"><a href="company-account">Benutzerkonto</a></li>
		</ul>
		<a href="#" class="logout">Logout</a>
		<div id="hamburger">
			<div class="line lineA"></div>
			<div class="line lineB"></div>
		</div>
	</nav>
	
	<div id="content" role="main">
		<div class="limit">
			<div class="content-header">
				<h1>Benutzerkonto</h1>
			</div>
			
			<div class="content-item content-account">
				<div class="content-row">
					<div class="content-col content-col-25">
						<div class="content-label">
							<label>Eingeloggt als</label>
						</div>
						<div class="account-content">
							<p>peter@hungry.at</p>
						</div>
						<div class="account-button">
							<a href="#" class="button">E-Mail-Adresse ändern</a>
						</div>
					</div><div class="content-col content-col-25">
						<div class="content-label">
							<label>Ihre Daten</label>
						</div>
						<div class="account-content">
							<ul class="datalist">
								<li><span>Paket: </span>Peter</li>
								<li><span>Nachname: </span>Rohrmoser</li>
							</ul>
						</div>
						<div class="account-button">
							<a href="#" class="button">Benutzerdaten ändern</a>
						</div>
					</div><div class="content-col">
						<div class="content-label">
							<label>Konto schliessen</label>
						</div>
						<div class="account-content">
							<p>Sie können Ihr Benutzerkonto jederzeit schließen. Das Schließen hat u.a. folgende Konsequenzen:</p>
							<ul class="list">								
								<li>Sie können sich nicht mehr anmelden und bAware nicht mehr nutzen</li>
								<li>Sie verlieren Ihren Schulungsfortschritt</li>
								<li>Sie haben keinen Zugriff mehr auf Ihre Schulungszertifikate</li>
								<li>Ihre Daten werden vollständig und irreversibel aus unserem System entfernt</li>
							</ul>
						</div>
						<div class="account-button">
							<a href="#" class="button">Konto schliessen</a>
						</div>
					</div>
			
				</div>
			</div>
		</div>	
	</div>
	
	<footer id="footer">
		<ul>
			<li><a href="#">Datenschutz</a></li>
			<li><a href="#">Impressum</a></li>
			<li><a href="#">Support</a></li>
		</ul>
		<a href="/" class="footer-logo">
			<img src="assets/svg/logo-blue.svg" alt="mindsetters">
		</a>
	</footer>
</div>


<script src="assets/js/plugins.js?<?php echo time(); ?>"></script>
<script src="assets/js/javascript.js?<?php echo time(); ?>"></script>

</body>
</html>
