<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="de"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8" lang="de"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9" lang="de"> <![endif]-->
<!--[if gt IE 8]><!-->

<html class="no-js" lang="de">
<!--<![endif]-->

<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">

<title>Signup — mindsetters</title>

<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="apple-touch-icon" sizes="180x180" href="assets/favicons/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="assets/favicons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="assets/favicons/favicon-16x16.png">
<link rel="manifest" href="assets/favicons/site.webmanifest">
<link rel="mask-icon" href="assets/favicons/safari-pinned-tab.svg" color="#242858">
<link rel="shortcut icon" href="assets/favicons/favicon.ico">
<meta name="msapplication-TileColor" content="#242858">
<meta name="msapplication-config" content="assets/favicons/browserconfig.xml">
<meta name="theme-color" content="#242858">

<link rel="stylesheet" href="assets/css/styles.css?<?php echo time(); ?>">

<script src="assets/js/jquery.js?<?php echo time(); ?>"></script>
<script src="assets/js/jquery-migrate.js?<?php echo time(); ?>"></script>
<script src="assets/js/modernizr.js"></script>



</head>

<body>
	
	<div id="loginscreen">
		<div class="login-row">
			<div class="login-col register-col">
				<div class="login-content">					
					<h1>Unternehmen registrieren</h1>
					
					<div class="login-form">
						<form>
							<div class="form-row">
								<div class="form-col form-col-100">
									<div class="form-item">
										<label for="form-company">Firmenname<sup>*</sup></label>
										<input type="text" name="company" id="form-company">
									</div>
								</div>
								
								<div class="form-col form-col-100">
									<div class="form-item">
										<label for="form-street">Strasse, Nr.</label>
										<input type="text" name="street" id="form-street">
									</div>
								</div>
								
								<div class="form-col form-col-35">
									<div class="form-item">
										<label for="form-zip">PLZ</label>
										<input type="text" name="zip" id="form-zip">
									</div>
								</div><div class="form-col form-col-65">
									<div class="form-item">
										<label for="form-city">Stadt</label>
										<input type="text" name="city" id="form-city">
									</div>
								</div>
								
								<div class="form-col form-col-100">
									<div class="form-item">
										<label for="form-uid">UID</label>
										<input type="text" name="uid" id="form-uid">
									</div>
								</div>
								
								<div class="form-col form-col-50">
									<div class="form-item">
										<label for="form-firstname">Vorname</label>
										<input type="text" name="firstname" id="form-firstname">
									</div>
								</div><div class="form-col form-col-50">
									<div class="form-item">
										<label for="form-lastname">Nachname</label>
										<input type="text" name="lastname" id="form-lastname">
									</div>
								</div>
								
								<div class="form-col form-col-50">
									<div class="form-item">
										<label for="form-email">E-Mail Adresse</label>
										<input type="text" name="email" id="form-email">
									</div>
								</div><div class="form-col form-col-50">
									<div class="form-item">
										<label for="form-phone">Telefonnummer</label>
										<input type="text" name="phone" id="form-phone">
									</div>
								</div>
								
								<div class="form-col form-col-100">
									<div class="form-item">
										<label for="form-password">Passwort</label>
										<input type="password" name="password" id="form-password">
									</div>
								</div>
							</div>
							
							<div class="form-legal">
								<div class="legal-check">
									<label id="terms-label">
										<input type="checkbox" id="terms-checkbox" name="termscheck" class="legalcheck" value="Zustimmung AGB">
										<span class="check" role="checkbox" aria-checked="false" aria-labelledby="terms-label"></span>
										<span class="labeltext">Ich akzeptiere die <a href="agb-url" target="_blank">AGB</a>.</span>
									</label>
									
								</div>
								<div class="legal-check">
									<label id="privacy-label">
										<input type="checkbox" id="privacy-checkbox" name="privacycheck" class="legalcheck" value="Zustimmung Datenschutu">
										<span class="check" role="checkbox" aria-checked="false" aria-labelledby="privacy-label"></span>
										<span class="labeltext">Ich akzeptiere die <a href="datenschutz-url" target="_blank">Datenschutz-Bestimmungen</a>.</span>
										</label>
									</label>
								</div>
							</div>
							
							<div class="form-button">
								<ul class="buttons">
									<li><button class="button send-button">Registrierung absenden</button></li>
									<li><a href="login" class="button">Zurück zum Login</a></li>
								</ul>
							</div>
						</form>
					</div>
				</div>
			</div>
			<div class="login-col login-col-intro bg-cover" style="background-image:url(assets/img/gradient-login.jpg)">
				<a href="/" class="mindsetters-icon"><img src="assets/svg/icon-white.svg" alt="mindsetters"></a>
				<div class="login-intro">
					<h2>Awareness Training für&nbsp;Ihr Unternehmen.</h2>
					<div class="intro-text">
						<p>Data Breaches finden sich in 91&nbsp;% aller Web-Applikationen wieder. In 84&nbsp;% der Web-Applikationen können Angreifer unberechtigten Zugriff erlangen. Und in 98&nbsp;% aller Web-Applikationen können End-Nutzer direkt angegriffen werden. Über einen Web-Applikationstest können diese Schwachstellen gefunden werden, bevor ein Angriff stattfindet.</p>
					</div>
					<div class="intro-button">
						<a href="login" class="button">zum Plattform Login</a>
					</div>
				</div>
				<div class="login-intro-nav">
					<ul>
						<li><a href="#">Datenschutz</a></li>
						<li><a href="#">Impressum</a></li>
						<li><a href="#">Support</a></li>
					</ul>
				</div>
			</div>
		</div>
	</div>


<script src="assets/js/plugins.js?<?php echo time(); ?>"></script>
<script src="assets/js/javascript.js?<?php echo time(); ?>"></script>

</body>
</html>
