<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="de"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8" lang="de"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9" lang="de"> <![endif]-->
<!--[if gt IE 8]><!-->

<html class="no-js" lang="de">
<!--<![endif]-->

<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">

<title>Login — mindsetters</title>

<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="apple-touch-icon" sizes="180x180" href="assets/favicons/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="assets/favicons/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="assets/favicons/favicon-16x16.png">
<link rel="manifest" href="assets/favicons/site.webmanifest">
<link rel="mask-icon" href="assets/favicons/safari-pinned-tab.svg" color="#242858">
<link rel="shortcut icon" href="assets/favicons/favicon.ico">
<meta name="msapplication-TileColor" content="#242858">
<meta name="msapplication-config" content="assets/favicons/browserconfig.xml">
<meta name="theme-color" content="#242858">

<link rel="stylesheet" href="assets/css/styles.css?<?php echo time(); ?>">

<script src="assets/js/jquery.js?<?php echo time(); ?>"></script>
<script src="assets/js/jquery-migrate.js?<?php echo time(); ?>"></script>
<script src="assets/js/modernizr.js"></script>



</head>

<body>
	
	<div id="loginscreen">
		<div class="login-row">
			<div class="login-col login-col-form">
				<div class="login-content">
					<div class="login-logo">
						<img src="assets/svg/logo-blue.svg" alt="mindsetters">
					</div>
					
					<h1>bAware Login</h1>
					
					<div class="login-form">
						<form>
							<div class="form-row">
								<div class="form-col form-col-100">
									<div class="form-item">
										<label for="form-email">E-Mail Adresse</label>
										<input type="text" name="email" id="form-email" class="not-valid">
										<p class="form-error">Fehlermeldung</p>
									</div>
								</div>
								<div class="form-col form-col-100">
									<div class="form-item">
										<label for="form-password">Passwort</label>
										<input type="password" name="password" id="form-password">
										<p>Passwort vergessen? <a href="">Passwort zurücksetzen</a></p>
									</div>
								</div>
							</div>
							<div class="form-button">
								<button class="button send-button">Login</button>
							</div>
						</form>
					</div>
					
					<div class="no-account">
						<h2>Sie haben noch keinen Account?</h2>
						<ul class="buttons">
							<li><a href="user-signup" class="button">Registrieren</a></li>
							<li><a href="company-signup" class="button">Unternehmen registrieren</a></li>
						</ul>
					</div>
				</div>
			</div>
			<div class="login-col login-col-intro bg-cover" style="background-image:url(assets/img/gradient-login.jpg)">
				<a href="/" class="mindsetters-icon"><img src="assets/svg/icon-white.svg" alt="mindsetters"></a>
				<div class="login-intro">
					<h2>Das richtige <br>Mindset finden.</h2>
					<div class="intro-text">
						<p>Data Breaches finden sich in 91&nbsp;% aller Web-Applikationen wieder. In 84&nbsp;% der Web-Applikationen können Angreifer unberechtigten Zugriff erlangen. Und in 98&nbsp;% aller Web-Applikationen können End-Nutzer direkt angegriffen werden. Über einen Web-Applikationstest können diese Schwachstellen gefunden werden, bevor ein Angriff stattfindet.</p>
					</div>
					<div class="intro-button">
						<a href="https://www.mindsetters.at" class="button">mindsetters.at</a>
					</div>
				</div>
				<div class="login-intro-nav">
					<ul>
						<li><a href="#">Datenschutz</a></li>
						<li><a href="#">Impressum</a></li>
						<li><a href="#">Support</a></li>
					</ul>
				</div>
			</div>
		</div>
	</div>


<script src="assets/js/plugins.js?<?php echo time(); ?>"></script>
<script src="assets/js/javascript.js?<?php echo time(); ?>"></script>

</body>
</html>
